 ; Ŀ
 ;   Vbox: draw a box delineating the current viewport.                    
 ;   Cord: append the coordinates to paper space matchline text.           
 ;   Copyright 2009, 2010 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Matchl - make a matchline co-ordinate string.              
 ;   Arguments: Soofa, the matchline ordinate.                             
 ;              Origs, the original string.                                
 ;   Calls Split.                                                          
 ;   Returns a string.                                                     
 ; 
 (DEFUN MATCHL (soofa origns / linn sub found)
 ; Ŀ
 ;   Extract the drawing name from the original string.                    
 ; 
  (setq linn (split origns))
  (while (and (null found) (setq sub (car linn)))
         (setq linn (cdr linn))
         (if (wcmatch sub "*-*-*-*")
             (setq found sub)))
 ; Ŀ
 ;   Make the new string.                                                  
 ; 
 (strcat "MATCHLINE" soofa " SEE DWG. " found))
 ; Ŀ
 ;   Matchl end.                                                           
 ; 

 ; Ŀ
 ;   Drama - draw a temporary marker box and possibly a polyline.          
 ;   Arguments: ll, the lower left corner.                                 
 ;              ul, the upper left corner.                                 
 ;              ur, the upper right corner.                                
 ;              lr, the lower right corner.                                
 ;              Ctr, the vport centre.                                     
 ;              Drawp, draw a polyline, t or nil.                          
 ;              Colo, the grdraw colour.  0 =  don't grdraw.               
 ;              Offs, a grdraw offset distance.                            
 ;                    If this is an integer then it is added to the        
 ;                    distance to the corners, so a negative integer       
 ;                    grdraws a box inside the vport.                      
 ;                    If it's a real then it is a distance multiplier.     
 ;                                                                         
 ;   Calls nothing.                                                        
 ;   Returns nothing.                                                      
 ; 
 (defun drama (ll ul ur lr ctr drawp colo offs / inll inul inur inlr)
 ; Ŀ
 ;   Make the inner points if they are required.                           
 ; 
  (cond ((zerop colo))
        ((= (type offs) 'REAL)
         (setq inll (polar ctr (angle ctr ll) (* (distance ctr ll) offs)))
         (setq inul (polar ctr (angle ctr ul) (* (distance ctr ul) offs)))
         (setq inur (polar ctr (angle ctr ur) (* (distance ctr ur) offs)))
         (setq inlr (polar ctr (angle ctr lr) (* (distance ctr lr) offs)))
         (grvecs (list colo inur inll inul inlr inul inur inur inlr inlr inll
                            inll inul)))
        (t
         (setq inll (polar ctr (angle ctr ll) (+ (distance ctr ll) offs)))
         (setq inul (polar ctr (angle ctr ul) (+ (distance ctr ul) offs)))
         (setq inur (polar ctr (angle ctr ur) (+ (distance ctr ur) offs)))
         (setq inlr (polar ctr (angle ctr lr) (+ (distance ctr lr) offs)))
         (grvecs (list colo inur inll inul inlr inul inur inur inlr inlr inll
                            inll inul))))
  (if drawp
     (command ".pline" ll ul ur lr "c"))
 (princ))
 ; Ŀ
 ;   Drama end.                                                            
 ; 

 ; Ŀ
 ;   Schist - rotate a list.                                               
 ;   Currently not called.                                                 
 ;   Arguments: Lisa, a list.                                              
 ;              Steps, the number of rotation steps.                       
 ;              If steps is positive then move the first element to the    
 ;              end, if negative then move the last element to the front.  
 ;   Calls nothing.                                                        
 ;   Returns the list.                                                     
 ; 
 (DEFUN SCHIST (lisa steps /)
  (setq steps (fix steps))   ; just to be a bit more bulletproof
  (if (minusp steps)
      (repeat (abs steps) (setq lisa (cons (last lisa)
                                           (reverse (cdr (reverse lisa))))))
      (repeat steps (setq lisa (append (cdr lisa) (list (car lisa))))))
 lisa)
 ; Ŀ
 ;   Schist end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Split - divide a text string at spaces, make into a list   
 ;   of substrings.                                                        
 ; 
 (DEFUN SPLIT (linn / strlst pos len name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) " ")
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
 strlst)
 ; Ŀ
 ;   Split end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Toaxe - append text to something.                          
 ;   Arguments: Rasp, a suffix string.                                     
 ;              Proma, a prompt, if nil then use the string in Rasp.       
 ;   Calls nothing, returns the ename of the selected text or nil.         
 ; 
 (DEFUN TOAXE (rasp proma / snapp *error* enam nent typ entt outer gnustr
                                                                   asoc1)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (defun *error* (shk /) (setvar "snapmode" snapp) (princ))
  (if (null proma)
      (setq proma (strcat rasp ": ")))
  (if (and (setq nent (nentsel proma))
           (setq enam (car nent)))
      (progn
           (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
           (if (or (= "TEXT" typ) (= "MTEXT" typ)
                   (= "ATTDEF" typ) (= "ATTRIB" typ))
               (progn
                    (setq outer (car (reverse (car (reverse nent)))))
                    (setq gnustr (strcat (cdr (setq asoc1 (assoc 1 entt)))
                                          rasp))
                    (entmod (subst (cons 1 gnustr) asoc1 entt))
                    (entupd enam)
                    (if (= (type outer) 'ENAME)
                        (entupd outer))))))
  (setvar "snapmode" snapp)
 enam)
 ; Ŀ
 ;   Subroutine Toaxe end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Tobxe - suck, rearrange, and rep[lace text.                
 ;   Arguments: Rasp, a string.                                            
 ;              Proma, a prompt, if nil then use the string in Rasp.       
 ;   Calls nothing, returns the ename of the selected text or nil.         
 ; 
 (DEFUN TOBXE (rasp proma / snapp *error* enam nent typ entt outer gnustr
                                                                   asoc1)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (defun *error* (shk /) (setvar "snapmode" snapp) (princ))
  (if (null proma)
      (setq proma (strcat rasp ": ")))
  (if (and (setq nent (nentsel proma))
           (setq enam (car nent)))
      (progn
           (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
           (if (or (= "TEXT" typ) (= "MTEXT" typ)
                   (= "ATTDEF" typ) (= "ATTRIB" typ))
               (progn
                    (setq outer (car (reverse (car (reverse nent)))))
                    (setq origg (cdr (setq asoc1 (assoc 1 entt))))
                    (setq gnustr (matchl rasp origg))
                    (entmod (subst (cons 1 gnustr) asoc1 entt))
                    (entupd enam)
                    (if (= (type outer) 'ENAME)
                        (entupd outer))))))
  (setvar "snapmode" snapp)
 enam)
 ; Ŀ
 ;   Subroutine Tobxe end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Topco - make a co-ordinate string from a number.           
 ;   Arguments: Pneuma, the number.                                        
 ;              Stra, the North/South/East/West pair first initial.        
 ;              Strb, the North/South/East/West pair second initial.       
 ;   Calls nothing.                                                        
 ;   Returns nothing.                                                      
 ; 
 (DEFUN TOPCO (pneuma stra strb / soofa vala len)
  (setq soofa (if (minusp pneuma) stra strb))
  (setq vala (rtos (abs pneuma) 2 0))
  (setq len (strlen vala))
  (if (> (strlen vala) 5)
      (progn
           (setq soofa (strcat soofa " " (substr vala 1 (- len 5)) "+"))
           (setq pneuma (substr vala (- len 4))))
      (setq soofa (strcat soofa " 0+")))
  (setq len (strlen vala))
 (strcat " " soofa (substr vala 1 (- len 3)) "." (substr vala (- len 2))))
 ; Ŀ
 ;   Topco end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Vb2 - find the corner points of the current vport.         
 ;   Argument: Show: draw an X delineating the viewport.                   
 ;   Calls nothing.                                                        
 ;   Returns a list of corner points and the centre.                       
 ;   Caution: doesn't work in model space.                                 
 ; 
 (defun VB2 (show / ports cvplis phwid phite vprato realht realwd ctr ctrx
                      ctry maxx minx maxy miny ll ul ur lr twist dill anll
                      gnull diul anul gnuul diur anur gnuur dilr anlr gnulr)
  (setq ports (vports))
 ; Ŀ
 ;   (Vports) returns a list of lists:                                     
 ;   ((viewport_id_No (lower_left_corner  upper_right_corner)) ...)        
 ;                                                                         
 ;   If Tilemode is 1 (model space), the list describes the ms viewports.  
 ;   If there are none then it will say one, from (0.0 0.0) to (1.0 1.0).  
 ;   (0.0, 0.0) is the ll corner of the screen and (1.0, 1.0) the ur.      
 ;                                                                         
 ;   If Tilemode is 0 (paper space), the list describes the viewports      
 ;   in paper space coordinates. Viewport number 1 is paper space.         
 ;   The current viewport is always first in the list.                     
 ;                                                                         
 ;   This means that we can get the size of the viewport from inside the   
 ;   viewport, i.e. in ms coordinates.                                     
 ; 
  (setq cvplis (cdar ports))
  (setq phwid (abs (- (caar cvplis) (caadr cvplis))))
  (setq phite (abs (- (cadar cvplis) (cadadr cvplis))))
  (setq vprato (/ phwid phite))
 ; Ŀ
 ;   Viewsize is the view height inside the current vport in drawing       
 ;   units, measured vertically on the screen regardless of viewtwist      
 ; 
  (setq realht (getvar "viewsize"))
  (setq realwd (* realht vprato))
 ; Ŀ
 ;   Viewctr is the centre of the screen, or of the current viewport       
 ;   if we are in one.                                                     
 ; 
  (setq ctr (getvar "viewctr"))
  (setq ctrx (car ctr))
  (setq ctry (cadr ctr))
 ; Ŀ
 ;   Make the four 'if the screen wasn't rotated' ordinates.               
 ; 
  (setq maxx (+ ctrx (/ realwd 2)))
  (setq minx (- ctrx (/ realwd 2)))
  (setq maxy (+ ctry (/ realht 2)))
  (setq miny (- ctry (/ realht 2)))
 ; Ŀ
 ;   These aren't that useful in a rotated viewport because they aren't    
 ;   constant, so get the four corner points.                              
 ; 
  (setq ll (list minx miny))
  (setq ul (list minx maxy))
  (setq ur (list maxx maxy))
  (setq lr (list maxx miny))
  (if show (drama ll ul ur lr ctr nil 8 0.98))
 ; Ŀ
 ;   Viewtwist is in degrees: Command: Viewtwist                           
 ;   or radians: (Getvar "viewtwist").                                     
 ; 
  (setq twist (getvar "viewtwist"))
 ; Ŀ
 ;   Find the quadrant points of the current vport in model space.         
 ; 
  (setq ptop (polar ctr (- (* pi 0.5) twist) (/ realht 2.0)))
  (setq prght (polar ctr (- twist) (/ realwd 2.0)))
  (setq pbot (polar ctr (- (* pi 1.5) twist) (/ realht 2.0)))
  (setq pleft (polar ctr (- pi twist) (/ realwd 2.0)))
 ; Ŀ
 ;   Grdraw some indicator lines if required.                              
 ; 
  (if show
     (progn
          (grdraw ctr ptop 1) (grdraw ctr prght 1) (grdraw ctr pbot 1)
          (grdraw ctr pleft 1) (grdraw ptop pleft 4) (grdraw pleft pbot 4)
          (grdraw pbot prght 4) (grdraw prght ptop 4)))
 ; Ŀ
 ;   Calculate the actual corner points based on the viewtwist.            
 ; 
  (setq dill (distance ctr ll))
  (setq anll (angle ctr ll))
  (setq gnull (polar ctr (- anll twist) dill))
  (setq diul (distance ctr ul))
  (setq anul (angle ctr ul))
  (setq gnuul (polar ctr (- anul twist) diul))
  (setq diur (distance ctr ur))
  (setq anur (angle ctr ur))
  (setq gnuur (polar ctr (- anur twist) diur))
  (setq dilr (distance ctr lr))
  (setq anlr (angle ctr lr))
  (setq gnulr (polar ctr (- anlr twist) dilr))
 ; Ŀ
 ;   Grdraw a corner to corner X if required.                              
 ; 
  (if show
      (progn
           (grdraw ctr gnull 3)
           (grdraw ctr gnuul 3)
           (grdraw ctr gnuur 3)
           (grdraw ctr gnulr 3)))
 ; Ŀ
 ;   Make a marker box just inside the vport so we can see if the          
 ;   calculated corners are accurate.                                      
 ;   Hang on - Drama can do this.                                          
 ; 
  (if show
     (drama gnull gnuul gnuur gnulr ctr nil 1 0.99))
 ; Ŀ
 ;   Return a list:                                                        
 ;   ((four corners) (four midpoints) viewtwist centre).                   
 ; 
 (list (list gnull gnuul gnuur gnulr) (list ptop prght pbot pleft) twist ctr))
 ; Ŀ
 ;   Subroutine Vb2 end.                                                   
 ; 

 ; Ŀ
 ;   Subroutine Wasp - are we in the Model Space Tab, Paper Space, or      
 ;   a viewport in Paper Space?                                            
 ;   Brooks no Arguments.                                                  
 ;   Calls nothing.                                                        
 ;   Returns: 1 - Model space.                                             
 ;            2 - Paper space.                                             
 ;            3 - A Viewport in Paper Space.                               
 ; 
 (DEFUN WASP ()
  (cond ((= (getvar "tilemode") 1) 1)
        ((= (getvar "cvport") 1) 2)
        (t 3)))
 ; Ŀ
 ;   Wasp end.                                                             
 ; 

 ; Ŀ
 ;   Cord - append vport coordinates to text.                              
 ;   Note that these are rounded to the next lowest unit, because ...      
 ;   this makes sense unless you are working in nautical miles.            
 ;   Argument: Typpe, the string format to use, "a" or "b".                
 ; 
 (defun CORD (typpe / *error* maxim twist maxx minx maxy miny top right down
                                                                   left sava)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Tell the user where he is, just in case.                              
 ; 
  (cond ((= (wasp) 1)
         (prompt "*** You are in Model Space. ***"))
        ((= (wasp) 2)
         (prompt "*** You are in Paper Space but not in a viewport. ***"))
        (t
 ; Ŀ
 ;   Vb2 returns ((ll ul ur lr) (topmid rgtmid botmid leftmid) twist ctr)  
 ; 
         (setq maxim (vb2 ()))
         (setq twist (caddr maxim))
         (setq maxim (cadr maxim))      ; the second sublist
         (command ".pspace")
 ; Ŀ
 ;   It is possible that the view may have been rotated.                   
 ;   (Assuming that North was increasing Y before the view was rotated.)   
 ;   It isn't possible to attach a Northing or Easting to a diagonal       
 ;   line, so we will allow for only rotations in multiples of 90.        
 ;   Note: although the viewport is rotated we are assuming that           
 ;   the highest X is still North and so on.  We have to label the side    
 ;   of the viewport corresponding to this as North depending on which     
 ;   way the viewport is rotated: must find the paper space direction      
 ;   which matches North etc. in the viewport.                             
 ;   If the base model isn't in real world co-ordinates or North isn't     
 ;   up then Crad won't work and you are on your own - this program        
 ;   is based on conventions rather than eternal mathematical truths.      
 ;                                                                         
 ;   Basically the midpoint coordinates are always oriented the same, so   
 ;   We just have to figure which way in the vport is up and whether to    
 ;   use the x or y ordinate and whether up is N or E.                     
 ;                                                                         
 ;   0 (the reference case): MS North faces PS top.                       
 ;   or 180: MS North faces PS down.                                      
 ; 
         (cond ((or (equal twist 0 0.01)            ; 0
                    (equal twist pi 0.01))          ; 180
                (prompt (strcat "\nView Twist Angle: "
                                (rtos (* twist (/ 180 pi)) 2 1)))
                (setq maxx (car (cadr maxim)))
                (setq minx (car (cadddr maxim)))
                (setq maxy (cadr (car maxim)))
                (setq miny (cadr (caddr maxim)))
 ; Ŀ
 ;   Make the coordinate strings.                                          
 ; 
                (setq top (topco maxy "S" "N"))
                (setq right (topco maxx "W" "E"))
                (setq down (topco miny "S" "N"))
                (setq left (topco minx "W" "E")))
 ; Ŀ
 ;   90: MS North faces PS left.                                          
 ;   or 270: MS North faces PS right.                                     
 ; 
               ((or (equal twist (/ pi 2) 0.01)     ; 90
                    (equal twist (* pi 1.5) 0.01))  ; 270
                (prompt (strcat "\nView Twist Angle: "
                                (rtos (* twist (/ 180 pi)) 2 1)))
                (setq maxx (cadr (cadr maxim)))
                (setq minx (cadr (cadddr maxim)))
                (setq maxy (car (car maxim)))
                (setq miny (car (caddr maxim)))
 ; Ŀ
 ;   Make the coordinate strings.                                          
 ; 
                (setq top (topco maxy "W" "E"))
                (setq right (topco maxx "S" "N"))
                (setq down (topco miny "W" "E"))
                (setq left (topco minx "S" "N")))
 ; Ŀ
 ;   Something else, and this is not a good idea.                          
 ; 
              (T
               (prompt (strcat "\nUnknown View Twist Angle: "
                               (rtos (* twist (/ 180 pi)) 2 1)
                               " - Please Think Before Continuing."))))
 ; Ŀ
 ;   Install the coordinate strings.                                       
 ; 
         (cond ((and top (= typpe "a"))
                (toaxe top (strcat "\nTop Coord (" (substr top 2) "):"))
                (toaxe right (strcat "\nRight Coord (" (substr right 2) "):"))
                (toaxe down (strcat "\nBottom Coord (" (substr down 2) "):"))
                (toaxe left (strcat "\nLeft Coord (" (substr left 2) "):")))
               ((and top (= typpe "b"))
                (tobxe top (strcat "\nTop Coord (" (substr top 2) "):"))
                (tobxe right (strcat "\nRight Coord (" (substr right 2) "):"))
                (tobxe down (strcat "\nBottom Coord (" (substr down 2) "):"))
                (tobxe left (strcat "\nLeft Coord (" (substr left 2) "):"))))))
 (princ))
 ; Ŀ
 ;   Subroutine Cord end.                                                  
 ; 

 ; Ŀ
 ;   Card - append vport coordinates to text - long form, assumes that     
 ;   there is a file name of the form *-*-*-* in the existing text line.   
 ; 
 (DEFUN C:CARD ()
  (cord "b")
 (princ))
 ; Ŀ
 ;   Card end.                                                             
 ; 

 ; Ŀ
 ;   Cord - append vport coordinates to text.                              
 ; 
 (DEFUN C:CORD ()
  (cord "a")
 (princ))
 ; Ŀ
 ;   Cord end.                                                             
 ; 

 ; Ŀ
 ;   Vbox.                                                                 
 ; 
 (defun C:VBOX (/ *error* maxim ll ul ur lr ctr)
  (setvar "cmdecho" 0)
  (cond ((= (wasp) 1)
         (prompt "* You are in Model space. *"))
        ((= (wasp) 2)
         (prompt "* You must be in a viewport. *"))
 ; Ŀ
 ;   We are in a viewport in paper space and thus ready to go.             
 ; 
        (t
 ; Ŀ
 ;   Vb2 returns ((ll ul ur lr) (topmid rgtmid botmid leftmid) twist ctr)  
 ; 
         (setq maxim (vb2 nil))
         (setq ctr (last maxim))
         (setq maxim (car maxim))
         (setq ll (car maxim))
         (setq ul (cadr maxim))
         (setq ur (caddr maxim))
         (setq lr (cadddr maxim))
 ; Ŀ
 ;   Draw the marker box and the polyline.                                 
 ; 
         (drama ll ul ur lr ctr t 1 0.975)))
 (princ))